<?php

session_start();
if (isset($_POST)){
	include_once('../config/db.php');
	include('../config/validation.php');
	$errorMessages = array();

	foreach ($_POST as $key=>&$val){
		$val = trim($val);
		$_SESSION[$key]=$val;
		if ($val==''){
			$key = str_replace('_', ' ', $key);
			$errorMessages[] = 'The field <em>'.$key.'</em> was empty.';
		}
		$val = quote($val);
	}
	if (sizeof($errorMessages)>0){
		$errorMessages[]='(All fields are required)';
	}
	//no need for advanced checks when fields are missing
	if (sizeof($errorMessages)==0){
		if ($_POST['Password']!=$_POST['Retype_Password']){
			$errorMessages[]='The two passwords were not identical.';
		} else {
			if (strlen($_POST['Password'])<6){
				$errorMessages[] = 'The Password was very short, minimum length is six (6) characters.';
			}
			if ($_POST['Password']==$_POST['Email'] || $_POST['Password']==$_POST['Username']){
				$errorMessages[] = 'The requested Password is identical to either the Email or the Username, please choose a different one.';
			}
		}

		if (!isEmailValid($_POST['Email'])){
			$errorMessages[]='The entered Email does not appear to be valid.';
		}
		if (!isUsernameAvailable($_POST['Username'])){
			$errorMessages[]='The entered Username already exists in the database.';
		}
		if (!isEmailAvailable($_POST['Email'])){
			$errorMessages[]='The entered Email already exists in the database, <a href="../lostPassword.php">did you loose your password?</a>.';
		}
	}
	if (sizeof($errorMessages)>0){
		$_SESSION['errorMessages']=implode('|', $errorMessages);
		header("Location: index.php");
	} else {
		include('../classes/Member.php');
		//skal pakkes ind i if(){}
		$m = new Member(-10, $_POST['Username'], $_POST['Email'], 0, $_POST['Password'], 1);
		
		include('../classes/MailClass.php');
		$body ="<strong>Welcome to Doing Foresight</strong><br />Enclosed you will find your 
username and password for the site \"".SITENAME."\" <br />Please keep 
this mail for future references as we have not kept your password<br 
/>Should you loose this information, a new password can be created for 
you, please see <a href='".URL."login/lostpassword.php'>Lost Password</a><br />Password: ".$_POST['Password']."<br 
/><br />Username: ".$_POST['Username']."<br /><br />We hope that you 
find this service interesting and encourage you to send 
feedback to <a href='mailto:ah@tekno.dk'>ah@tekno.dk</a>";
		if (!$mail = new MailClass($_POST['Email'], 'Welcome to '.SITENAME, $body, TRUE)){
			die("Your account was created, but your password and username could not be sent to your email, please note them down for future use");
		}
		foreach ($_POST as $key=>&$val){
			unset($_SESSION[$key]);
		}
		unset($_SESSION['errorMessages']);
		header("Location: accountCreated.php");
	}
}
?>
