<?php
ini_set('max_execution_time', 300);
include("config.inc.php");
define('FPDF_FONTPATH','font/');

class PDF extends FPDF {
	private $header;
	private $pageNums=array(),$labels=array(); 
	private $selectedRoles='', $selectedProblems='';
	private $methodIDs = array();
	private $methodCoverage = array();
	private $selectedEP;
	private $headAr=array();
	private $customFCHeaders=array();
	private $nextIndex, $subIndex;
	public $pid;
	private $roleSendstring;
	public $reversedConditions;
	private $methodCoverageLetters = array('a'=>'', 'b'=>'', 'c'=>'', 'd'=>'', 'e'=>'', 'f'=>'', 'g'=>'', 'h'=>'', 'i'=>'', 'j'=>'', 'k'=>'', 'l'=>'', 'm'=>'', 'n'=>'', 'o'=>'', 'p'=>'', 
'q'=>'', 'r'=>'', 's'=>'', 't'=>'', );
	private $evalSendString;
	private $fcheaders = array();
	
	function nextIndex(){
		$this->nextIndex++;
		$this->subIndex=0;
		return $this->nextIndex; 
	}
	function subIndex(){
		$this->subIndex++;
		return $this->nextIndex.".".$this->subIndex; 
	}
	function setHeader($h){
		$this->header = $h;
	}
	function Header() {
	    $this->Image('img/logoPDFtrans.png',10,8,60);
	    $this->SetFont('Arial','B',15);
	    $this->Cell(80);
	    $this->Cell(30,10,$this->header,0,0,'C');
	    $this->Ln(20);
	}
	function ChapterTitle($num,$label, $main=true){
		$this->Ln(4);
		if($main){
			$this->SetFont('Arial','B',12);
		} else {
			$this->SetFont('Arial','',12);
		}
	    $this->SetFillColor(200,220,255);
	    $this->Cell(0,6,"Part $num : $label",0,1,'L',1);
	    $this->Ln(4);
	}
	function ChapterBody($txt, $close=false){
	    $this->SetFont('Times','',12);
	    $this->MultiCell(0,5,strip_tags($txt));
	    if(!$close){
	    	$this->Ln();
	    }
	}
	function BasicTable($header,$data) {
		$this->SetFont('Times','B',12);
		$this->Cell(40,6,$header,0);
		$this->Ln();
		$this->SetFont('Times','',12);
	    for($i=0; $i<sizeof($data); $i=$i+2){
	        $this->Cell(140,6,$data[$i],0);
	        $this->Cell(40,6,$data[$i+1],0);
	        $this->Ln();
	    }
	}
	function Table21($header='',$data) {
		$this->SetFont('Times','B',12);
		$this->Cell(40,6,$header,0);
		$this->Ln();
		$this->SetFont('Times','',12);
	    for($i=0; $i<sizeof($data); $i=$i+3){
	        $this->Cell(140,6,$data[$i],0);
	        $this->Cell(40,6,$data[$i+1],0);
	        $this->Ln();
	        if($data[$i+2]!=''){
	        	$this->Cell(180,6,$data[$i+2],0);
	        	$this->Ln();
	        }
	    }
	}
	function BasicBoldTable($header,$data) {
	    for($i=0; $i<sizeof($data); $i=$i+2){
	    	 $this->SetFont('Times','B',12);
	        $this->Cell(60,6,$data[$i].":",0);
	         $this->SetFont('Times','',12);
	        $this->Cell(40,6,$data[$i+1],0);
	        $this->Ln();
	    }
	}
	
	function HeaderArrayBody($header,$data) {
		$this->SetFont('Times','B',12);
		$this->Cell(40,6,$header,0);
		$this->Ln();
		$this->SetFont('Times','',12);
	    for($i=0; $i<sizeof($data); $i++){
	    	if($data[$i]!=''){
		        $this->Cell(140,6,$data[$i],0);
		        $this->Ln();
	    	}
	    }
	    if(sizeof($data)==0){
	    	 $this->Cell(140,6,"None",0);
		        $this->Ln();
	    }
	}
	function WriteHTML($html) {
	    //HTML parser
	    $html=str_replace("\n",' ',$html);
	    $html=str_replace("<p>","\n",$html);
	    $html=str_replace("</p>","\n",$html);
	    $html=str_replace('strong>', 'b>', $html);
	    $a=preg_split('/<(.*)>/U',$html,-1,PREG_SPLIT_DELIM_CAPTURE);
	    foreach($a as $i=>$e) {
	        if($i%2==0) {
	            //Text
	            if($this->HREF)
	                $this->PutLink($this->HREF,$e);
	            else
	                $this->Write(5,$e);
	        } else {
	            //Tag
	            if($e{0}=='/')
	                $this->CloseTag(strtoupper(substr($e,1)));
	            else {
	                //Extract attributes
	                $a2=explode(' ',$e);
	                $tag=strtoupper(array_shift($a2));
	                $attr=array();
	                foreach($a2 as $v)
	                    if(ereg('^([^=]*)=["\']?([^"\']*)["\']?$',$v,$a3))
	                        $attr[strtoupper($a3[1])]=$a3[2];
	                $this->OpenTag($tag,$attr);
	            }
	        }
	    }
	}
	function SetStyle($tag,$enable) {
	    //Modify style and select corresponding font
	    $this->$tag+=($enable ? 1 : -1);
	    $style='';
	    foreach(array('B','I','U') as $s)
	        if($this->$s>0)
	            $style.=$s;
	    $this->SetFont('',$style);
	}
	function OpenTag($tag,$attr) {
	    //Opening tag
	    if($tag=='B' or $tag=='EM' or $tag=='U')
	        $this->SetStyle($tag,true);
	    if($tag=='A')
	        $this->HREF=$attr['HREF'];
	    if($tag=='BR')
	        $this->Ln(5);
	}
	function CloseTag($tag) {
	    //Closing tag
	    if($tag=='B' or $tag=='EM' or $tag=='U')
	        $this->SetStyle($tag,false);
	    if($tag=='A')
	        $this->HREF='';
	}
	function PutLink($URL,$txt) {
	    //Put a hyperlink
	    $this->SetTextColor(0,0,255);
	    //$this->SetStyle('U',true);
	    $this->Write(5,$txt,$URL);
	    //$this->SetStyle('U',false);
	    $this->SetTextColor(0);
	}
	//Page footer
	function Footer() {
	    //Position at 1.5 cm from bottom
	    $this->SetY(-15);
	    $this->SetFont('Arial','I',8);
	    $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}: generated on '.date("Y-m-d"),0,0,'C');
	}
	
	private function PrintOwnText($header, $text){
		$this->SetFont('Times','B',12);
		$this->Cell(0,6,$header,0,1,'L');
		if($text==''){
			$text='No text entered';
		}
		$this->ChapterBody($text);
	}
	/*CONTENT, markup end*/
	
	function PrintProjectInfo($projectInfo){
		if($projectInfo){
			$this->ChapterTitle($this->nextIndex(), "Project Information");
			$res = mysql_query("SELECT name, descript, projectCreated, coordinatorname FROM projects WHERE projectID = $this->pid");
			$r = mysql_fetch_array($res);
			$data = array();
			$data[]="Project Name";
			$data[]=$r[0];
			$data[]="Comments";
			$data[]=$r[1];
			$data[]="Project Created";
			$data[]=$r[2];
			$data[]="Coordinator";
			$data[]=$r[3];
			$this->BasicBoldTable("Project information", $data);
			$this->Ln();
		}
	}
	
	/*Frame Conditions*/
	function uniqueHeaders($header){
		if(!in_array($header, $this->fcheaders) && $header !=''){
			$this->SetFont('Times','B',14);
			$this->Cell(0,6,$header,0,1,'L');
			$this->fcheaders[]=$header;
		}
	}
	function presentJ($ar,$h){
		$desc = array('Initiating', 'Financing', 'Executing');
		for($i=0;$i<sizeof($ar); $i++){
			if($ar[$i]!=''){
				$this->uniqueHeaders($h);
				$this->SetFont('Times','B',12);
				$this->Cell(0,6,$desc[$i],0,1,'L');
				$this->SetFont('Times','',12);
				$this->Write(5,nl2br($ar[$i]));
				$this->Ln();
			}
		}
		if(is_array($ar)){
		  return (int)array_sum($ar);
		} else {
		  return 0;
		}
		
	}
	function presentK($ar, $h){
		$desc = array('Financial  (min)','Financial  (max)', 'Man months (min)', 'Man months (max)');
		for($i=0;$i<sizeof($ar); $i++){
			if($ar[$i]!='' && $ar[$i]!=0){
				$this->uniqueHeaders($h);
				$this->SetFont('Times','B',12);
				$this->Cell(0,6,$desc[$i],0,1,'L');
				$this->SetFont('Times','',12);
				$this->Write(5,nl2br($ar[$i]));
				$this->Ln();
			}
		}
		if(is_array($ar)){
		  return (int)array_sum($ar);
		} else {
		  return 0;
		}
	}
	function presentM($ar, $h){
		$desc = array('Start', 'Max');
		for($i=0;$i<sizeof($ar); $i++){
			if($ar[$i]!=0 && $ar[$i]!=''){
				$this->uniqueHeaders($h);
				$this->SetFont('Times','B',12);
				$this->Cell(0,6,$desc[$i],0,1,'L');
				$this->SetFont('Times','',12);
				$this->Write(5,nl2br($ar[$i]));
				$this->Ln();
			}
		}
		if(is_array($ar)){
		  return (int)array_sum($ar);
		} else {
		  return 0;
		}
	}
	function presentO($ar, $h){
		$desc = array('Categories, brainstorm');
		for($i=0;$i<sizeof($ar); $i++){
			if($ar[$i]!=''){
				$this->uniqueHeaders($h);
				$this->SetFont('Times','B',12);
				$this->Cell(0,6,$desc[$i],0,1,'L');
				$this->SetFont('Times','',12);
				$this->Write(5,nl2br($ar[$i]));
				$this->Ln();
			}
		}
		if(is_array($ar)){
		  return (int)array_sum($ar);
		} else {
		  return 0;
		}
	}
	function presentCustom($fcid, $ar, $h=''){
		switch($fcid){
			case 15:
				$i=$this->presentJ($ar,$h);
				break;
			case 16:
				$i=$this->presentK($ar,$h);
				break;
			case 17:
				$i=$this->presentM($ar,$h);
				break;
			case 19:
				$i=$this->presentO($ar,$h);
				break;
		}
		return $i;
	}
	function showSelectedChildren($header, $fcid){
		$customDesc = array(15,16,17,19);
		$fields =array(
			15=>'org_init,org_finance,org_exec',
			16=>'min_cost_financial,max_cost_financial,min_cost_staff,max_cost_staff',
			17=>'duration_start,duration_max',
			19=>'main_actors');
		$res = mysql_query("SELECT header, c.cid FROM conditions c, conditionanswers ca WHERE header <> 'Not relevant' AND fcid=$fcid AND c.cid=ca.cid AND projectID = $this->pid");
		if(mysql_num_rows($res)>0){
			$this->SetFont('Times','B',12);
			$this->Cell(0,6,$header,0,1,'L');
			$this->SetFont('Times','',12);
			while($r = mysql_fetch_array($res)){
				$this->Write(5,$r[0]);
				$this->Ln();
			}
			if(in_array($fcid, $customDesc)){
				$customQ = mysql_query("SELECT ".$fields[$fcid]." FROM projects WHERE projectID = $this->pid");
				$c = mysql_fetch_array($customQ, MYSQL_NUM);
				$this->presentCustom($fcid, $c);
			}

			return 1;
		} elseif (in_array($fcid, $customDesc)){ 
			switch($fcid){
				case 15:
					$h="Organisation";
					break;
				case 16:
					$h="Cost";
					break;
				case 17:
					$h="Duration of the project";
					break;
				case 19:
					$h="Main Actors";
					break;
			}
			
			$customQ = mysql_query("SELECT ".$fields[$fcid]." FROM projects WHERE projectID = $this->pid");
			$c = mysql_fetch_array($customQ, MYSQL_NUM);
			$i=$this->presentCustom($fcid, $c, $h);
			
			return $i;
		}else {
			return 0;
		}
	}
	
	function fcSummary(){
		$i=0;
		$res = mysql_query("SELECT fcid, header FROM frameconditions ORDER BY fcid");
		while($fc = mysql_fetch_array($res)){
			$i+=$this->showSelectedChildren($fc[1], $fc[0]);
		}
		return $i;
	}
	/**/
	function PrintFC($fc){
		if($fc){
			$this->ChapterTitle($this->nextIndex(), "Frame Conditions");
			$count=0;
			$count += $this->fcSummary();
			if($count==0){
				$this->SetFont('Times','B',12);
				$this->Cell(0,6,"No Frame Conditions selected",0,1,'L');
				
			}
		}
	}
	/*Problem Phase*/
	function PrintPP($backgroundInfo, $identifiedProblems, $descriptions){
		if($backgroundInfo){
			$this->ChapterTitle($this->nextIndex(), "Background Info");
			$this->PrintPPBackgroundInfo();
		}
		if($identifiedProblems){
			$this->ChapterTitle($this->nextIndex(), "Identified Problems");
			$this->PrintPPIdentifiedProblems();
			if($descriptions){
				$this->ChapterTitle($this->subIndex(), "Problem Descriptions", false);
				$this->PrintPPDescriptions();
			}
		}
	}
	
	private function PrintPPBackgroundInfo(){
		$res = mysql_query("SELECT pd_current, pd_actors FROM projects WHERE projectID = $this->pid");
		$r = mysql_fetch_array($res);
		$this->PrintOwnText("The current situation", $r[0]);
		$this->PrintOwnText("Actors and Concerns", $r[1]);
	}
	private function PrintPPIdentifiedProblems(){
		$res = mysql_query("SELECT problemLetter, problemShort, value, p.problemID, comment FROM problems p, problemanswers pa WHERE p.problemID = pa.problemID AND projectID = $this->pid AND (value > 0 OR comment <> '') ORDER BY value DESC");
		$problems = array();
		$high = array();
		$low=array();
		$not=array();
		while($r = mysql_fetch_array($res)){
			if($r[2]>2){
				$high[] = $r[0].') ' .$r[1];
				$high[] = $r[4];
				$this->selectedProblems.=$r[3].',';
			} elseif($r[2]>0){
				$low[] = $r[0].') ' .$r[1];
				$low[] = $r[4];
				$this->selectedProblems.=$r[3].',';
			} else {
				$not[] = $r[0].') ' .$r[1];
				$not[] = $r[4];
				$this->selectedProblems.=$r[3].',';
			}
		}
		$this->selectedProblems.='0';
		
		$this->HeaderArrayBody("Major Problems", $high);
		$this->HeaderArrayBody("Minor Problems", $low);
		$this->HeaderArrayBody("Not Rated", $not);
	}
	private function PrintPPDescriptions(){
		$res = mysql_query("SELECT * FROM problems WHERE problemID IN ($this->selectedProblems)");
		while($r=mysql_fetch_array($res)){
			$this->SetFont('Times','B',14);
			$this->MultiCell(0,5,$r['problemShort']);
			$this->SetFont('Times','B',12);
			$this->MultiCell(0,5,"Is this a problem?");
			$this->SetFont('Times','',12);
			$this->ChapterBody(strip_tags($r['problemMore']));
			 $this->SetFont('Times','B',12);
			$this->MultiCell(0,5,"What is the problem?");
			$this->SetFont('Times','',12);
			$this->ChapterBody(strip_tags($r['problemWhat']));
			$this->Ln();
		}
		
	}
	/*Problem Phase end*/
	
	/*Role selection*/
	function PrintRS($initialGoal, $selectedRoles, $descriptions, $warnings, $comparison, $graph, $goalSettings){
		if($initialGoal){
			$this->ChapterTitle($this->nextIndex(), "Initial Goal Description");
			$this->PrintRSInitial();
		}
		if($selectedRoles){
			$this->ChapterTitle($this->nextIndex(), "Selected Roles");
			$this->PrintRSSelected();
			if($descriptions){
				if($warnings){
					$this->ChapterTitle($this->subIndex(), "Role Descriptions with warnings", false);
				} else {
					$this->ChapterTitle($this->subIndex(), "Role Descriptions", false);
				}
				$this->PrintRSDescriptions($warnings);
			}
		}
		if($comparison){
			$this->ChapterTitle($this->nextIndex(), "Role Selection - Comparison");
			$this->PrintRSComparison();
			if($graph){
				$this->ChapterTitle($this->subIndex(), "Role Selection, Graph", false);
				$this->PrintRSGraph();
			}
		}
		if($goalSettings){
			$this->ChapterTitle($this->nextIndex(), "Goal Settings");
			$this->PrintRSGoalSetting();
		}	
		
	}
	private function PrintRSInitial(){
		$res = mysql_query("SELECT rs_why_this_topic, rs_original_purpose FROM projects WHERE projectID = $this->pid");
		$r = mysql_fetch_array($res);
		$this->PrintOwnText("Topic", $r[0]);
		$this->PrintOwnText("Purpose", $r[1]);
	}
	private function PrintRSSelected(){
		$res = mysql_query("SELECT roleLetter, roleShort, value, r.roleID FROM roles r, roleanswers ra WHERE r.roleID = ra.roleID AND projectID = $this->pid AND value > 0 ORDER BY value DESC");
		$problems = array();
		$high = array();
		$low=array();
		
		while($r = mysql_fetch_array($res)){
			if($r[2]>2){
				$high[] = $r[0].') ' .$r[1];
				$high[] = $r[4];
				$this->selectedRoles.=$r[3].',';
			} elseif($r[2]>0){
				$low[] = $r[0].') ' .$r[1];
				$low[] = $r[4];
				$this->selectedRoles.=$r[3].',';
			}
		}
		$this->selectedRoles.='0';
		
		$this->HeaderArrayBody("High Ambition", $high);
		$this->HeaderArrayBody("Low Ambition", $low);
	}
	private function PrintRSDescriptions($warnings){
		if(strlen($this->selectedRoles)>0){
			$ins = explode('|', $this->selectedRoles);
			
			$in='';
			foreach($ins as $i){
				$in.=$i;
				if(next($ins)){
					$in.=',';
				}
			}
			$res = mysql_query("SELECT roleLetter, roleShort, roleMore, roleDangers, roleRelations, roleExamples, roleWhat, roleID FROM roles WHERE roleID IN($in)");
			while($r=mysql_fetch_array($res)){

				$this->SetFont('Times','',14);
				$this->Cell(0,6,$r[0].') '.$r[1],0,1,'L');
				if($r[2]!=''){
					$this->SetFont('Times','B',12);
					$this->Cell(0,6,"What is the role?",0,1,'L');
					$this->ChapterBody($r['roleWhat']);
				}
				if($r[3]!=''){
					$this->SetFont('Times','B',12);
					$this->Cell(0,6,"What can be gained by performing the role?",0,1,'L');
					$this->ChapterBody($r[3]);
				}
				if($r[4]!=''){
					$this->SetFont('Times','B',12);
				$this->Cell(0,6,"Barriers",0,1,'L');
					$this->ChapterBody($r[4]);
				}
				if($r[5]!=''){
					$this->SetFont('Times','B',12);
				$this->Cell(0,6,"Relations to other roles",0,1,'L');
					$this->ChapterBody($r[5]);
				}
				if($r[6]!=''){
					$this->SetFont('Times','B',12);
					$this->Cell(0,6,"Examples",0,1,'L');
					$this->ChapterBody($r[6]);
				}
				if($warnings){
					$this->PrintRoleWarnings($r[7]);
				}
			}
		} else {
			$this->Cell(0,6,"No roles selected",0,1,'L');
		}
	}
	private function PrintRoleWarnings($rid){
		$q = "SELECT message FROM conditionanswers ca, roleconditions rc WHERE ca.cid =rc.cid AND projectID = ".$this->pid." AND roleID = ".$rid;
		$res = mysql_query($q) or die($q);
		
		$res2 = mysql_query("SELECT group_concat(cid) FROM conditionanswers WHERE projectID=".$this->pid);
		$ins = mysql_fetch_array($res2);
		if(strlen($ins[0])>0){
			$ins = " AND rc.cid NOT IN ($ins[0]) ";
		} else {
			$ins = '';
		}
		
		$res2 = mysql_query(
			"SELECT message FROM roleconditions rc WHERE rc.cid IN ($this->reversedConditions) $ins AND roleID=".$rid) or die(mysql_error());
			
		if(mysql_num_rows($res)>0 OR mysql_num_rows($res2)){
			$this->SetFont('Times','B',12);
			$this->Cell(0,6,"Warnings:",0,1,'L');
			$this->SetFont('Times','',12);
			while($warning=mysql_fetch_array($res)){
				$this->WriteHTML($warning[0]);
				$this->Ln();
			}
			while($warning=mysql_fetch_array($res2)){
				$this->WriteHTML($warning[0]);
				$this->Ln();
			}
		}
	}
	
	private function PrintRSComparison(){
		$plotar = array();
		$match = array();
		$bigProblem = array();
		$bigAmbition = array();
		
		$qrq = "SELECT r.value, p.value, roleLetter FROM roleanswers r, problemanswers p, roles WHERE p.projectID =".$this->pid. " 
		AND r.projectID = ".$this->pid ." 
		AND r.roleID = roles.roleID AND p.problemID = r.roleID ORDER BY roleLetter";
		$qr = mysql_query($qrq) or die(mysql_error().$qrq);
		$count=0;
		while($r=mysql_fetch_array($qr)){
			if($r[0] > 0 || $r[1]>0){
				$count++;
				$plotar[] = $r[2].'|'.$r[1].'|'.$r[0];
				$calc = $r[0]-$r[1];
				if ($calc > 1){
					$bigAmbition[] = $r[2];
				} else if($calc < -1){
					$bigProblem[] = $r[2];
				} else {
					$match[] = $r[2];
				}
			}	
		}
		if($count==0){
			$mes = "No problems or roles selected";
		} else {
			$mes = "None";
		}
		$sendstring = '';
		foreach($plotar as $p){
			$this->roleSendstring.=$p.'*';
		}
		$this->SetFont('Times','B',12);
		$this->Cell(0,6,"The ambition level exceedes the problem",0,1,'L');
		$this->SetFont('Times','',12);
		$in = '';
		foreach($bigAmbition as $val){
			$in.=$val;
			if(next($bigAmbition)){
				$in.="','";
			}
		}
		$mq = mysql_query("SELECT problemShort, problemLetter FROM problems WHERE problemLetter IN ('$in')") or die(mysql_error());
		if(mysql_num_rows($mq)==0){$this->Write(5, $mes);$this->Ln();}
		while($mr = mysql_fetch_array($mq)){
			$this->Write(5, $mr[1].') '.$mr[0]);
			$this->Ln();
		}
		
		$own = mysql_query("SELECT rs_exceed, rs_equal, rs_less FROM projects WHERE projectID=$this->pid"); 
		$ownAr=mysql_fetch_array($own);
		$this->PrintOwnText('You ambitions are higher than the impact of the problem in the preceding roles. Why?', $ownAr[0]);
		$this->SetFont('Times','B',12);
		$this->Cell(0,6,"The ambition level matches the problem",0,1,'L');
		$this->SetFont('Times','',12);
		$in = '';
		foreach($match as $val){
			$in.=$val;
			if(next($match)){
				$in.="','";
			}
		}
		$mq = mysql_query("SELECT problemShort, problemLetter FROM problems WHERE problemLetter IN ('$in')") or die(mysql_error());
		
		if(mysql_num_rows($mq)==0){$this->Write(5, $mes);$this->Ln();}
		while($mr = mysql_fetch_array($mq)){
			$this->Write(5, $mr[1].') '.$mr[0]);
			$this->Ln();
		}
		
		$this->PrintOwnText('You ambitions equal the impact of the problem in the preceding roles. Why?', $ownAr[1]);
		$this->SetFont('Times','B',12);
		$this->Cell(0,6,"The problem exceedes the level of ambition",0,1,'L');
		$this->SetFont('Times','',12);
		$in = '';
		foreach($bigProblem as $val){
			$in.=$val;
			if(next($bigProblem)){
				$in.="','";
			}
		}
		
		$mq = mysql_query("SELECT problemShort, problemLetter FROM problems WHERE problemLetter IN ('$in')");
		if(mysql_num_rows($mq)==0){$this->Write(5, $mes);$this->Ln();}
		while($mr = mysql_fetch_array($mq)){
			$this->Write(5, $mr[1].') '.$mr[0]);
			$this->Ln();
		}
		$this->PrintOwnText('The impact of the problem exceeds the ambition for the preceding roles. Why?', $ownAr[2]);
	}
	private function PrintRSGraph(){
		include_once("saveSummaryGraph.php");
		saveImage($this->roleSendstring, "rsSummary.png");
		//$this->Image("tempImg/evSummary.png",25,25, 100, 100);
		if($this->GetY()>100){
			$this->AddPage();
			$y=25;
		} else {
			$y=$this->GetY()+5;
		}
		$this->Image("tempImg/rsSummary.png", 25, $y);
		$this->SetY($this->GetY()+150);
	}

	private function PrintRSGoalSetting(){
		$res = mysql_query("SELECT rs_contribution, rs_central FROM projects WHERE projectID=$this->pid");
		$r=mysql_fetch_array($res);
		$this->PrintOwnText("Aims", $r[0]);
		$this->PrintOwnText("Central questions", $r[1]);
	}
	/*Goal Setting ended*/
	
	/*Methods*/
	function PrintMethods($chosenMethods, $descriptions, $warnings, $rolesNotCovered){
		if($chosenMethods){
			$this->ChapterTitle($this->nextIndex(), "Chosen Methods");
			$this->PrintMethodChosenMethods();
			if($descriptions){
				if($warnings){
					$this->ChapterTitle($this->subIndex(), "Methods descriptions with warnings", false);
				} else {
					$this->ChapterTitle($this->subIndex(), "Methods descriptions", false);
				}
				$this->PrintMethodDescriptions($warnings);
			}
			if($rolesNotCovered){
				$this->ChapterTitle($this->subIndex(), "Roles Not covered", false);
				$this->PrintMethodRolesNotCovered();
			}
		}
	}
	
	private function assimilateArray($methodCoverage, $sqlAr){
		for($i=2; $i<sizeof($sqlAr)/2; $i++){
			if($sqlAr[$i]>0){
				$this->methodCoverage[chr($i+95)]= $sqlAr[$i];
			}
		}
		return $this->methodCoverage;
	}
	
	private function PrintMethodChosenMethods(){
		$res = mysql_query("SELECT m.methodID, m.name, a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t FROM methods as m, saved_methods as s WHERE projectID=$this->pid AND m.methodID=s.methodID");
		
		while($r=mysql_fetch_array($res)){
			$this->methodIDs[]=$r[0];
			$this->methodCoverage = $this->assimilateArray($this->methodCoverage, $r);
			$this->SetFont('Times','',12);
			$this->Cell(0,6,$r[1],0,1,'L');
		}
	}

	private function PrintMethodDescriptions($warnings){
		$res = mysql_query("SELECT m.methodID, m.name, body FROM methods as m, saved_methods as s WHERE projectID=$this->pid AND m.methodID=s.methodID");
		
		while($r=mysql_fetch_array($res)){
			$this->SetFont('Times','B',14);
			$this->Cell(0,6,$r[1],0,1,'L');
			$this->SetFont('Times','',12);
			$this->WriteHTML($r[2]);
			$this->Ln();
			
			if($warnings){
				$this->PrintMethodWarnings($r[0]);
				$this->Ln();
			}
		}
	}
	
	private function PrintMethodWarnings($mid){
		$printWarning = false;
		$res = mysql_query("SELECT DISTINCT warning FROM conditionanswers ca, methodconditions mc WHERE ca.cid =mc.cid AND mid = $mid  AND projectID=".$this->pid. " AND ca.cid NOT IN ($this->reversedConditions)");
		
		$in = mysql_query("SELECT group_concat(cid) FROM conditionanswers WHERE projectID=".$this->pid);
		$ins = mysql_fetch_array($in);
		if(strlen($ins[0])>0){
			$ins = " AND mc.cid NOT IN ($ins[0])";
		} else {
			$ins = '';
		}
		$q="SELECT DISTINCT warning FROM methodconditions mc WHERE mc.cid IN($this->reversedConditions) AND mid=$mid $ins";
		$res2 = mysql_query($q) or die(mysql_error().$q);
		
		if(mysql_num_rows($res)>0){
			$printWarning = true;
		} elseif(mysql_num_rows($res2)>0){
			$printWarning = true;
		}
		if($printWarning){
			$this->SetFont('Times','B',12);
			$this->Cell(0,6,"Warnings:",0,1,'L');
			$this->SetFont('Times','',12);
			while($warning=mysql_fetch_array($res)){
				$this->WriteHTML($warning[0]);
				$this->Ln();
			}
			while($warning=mysql_fetch_array($res2)){
				$this->WriteHTML($warning[0]);
				$this->Ln();
			}
		}
			
	}
	
	private function PrintMethodRolesNotCovered(){
		$rolesCovered = 0;
		$res = mysql_query("SELECT ra.roleID, roleLetter, roleShort FROM roleanswers ra, roles r WHERE ra.roleID = r.roleID AND value > 0 AND projectID = ".$this->pid);
		$this->SetFont('Times','B',12);
	    $this->Cell(40,6,"Roles not covered",0);
	    $this->Ln(4);
	    $this->SetFont('Times','',12);
		while($r = mysql_fetch_array($res)){
			$index = $r[1];
			if($this->methodCoverage[$index]==''){
				$rolesCovered++;
				$this->Cell(40,6,$r[2],0);
				$this->Ln(10);
			}
		}
		if($rolesCovered==0){
			$this->SetFont('Times','',12);
	        $this->Cell(40,6,"All roles are covered by the combination of chosen methods",0);
	        $this->Ln();
		}
	}
	/*Methods end*/
	
	/*Evaluation phase*/
	function PrintEP($documentation, $desc, $comparison, $graph, $impact){
		if($documentation){
			$this->ChapterTitle($this->nextIndex(), "Evaluation Phase, Documentation");
			$this->PrintEPDocumentation();
			if($desc){
				$this->ChapterTitle($this->subIndex(), "Evaluation Phase, Descriptions", false);
				$this->PrintEPDescriptions();
			}
		}
		if($comparison){
			$this->ChapterTitle($this->nextIndex(), "Evaluation Phase, Comparison");
			$this->PrintEPComparison();
			if($graph){
				$this->ChapterTitle($this->subIndex(), "Evaluation Phase, Graph", false);
				$this->PrintEPGraph();
			}
		}
		if($impact){
			$this->ChapterTitle($this->nextIndex(), "Evaluation Phase, Impact of the Project");
			$this->PrintEPImpact();
		}
	}
	private function PrintEPDocumentation(){
		$res = mysql_query("SELECT epLetter, epShort, value, e.epID, comment FROM ex_post e, ex_post_answers ea WHERE e.epID = ea.epID AND projectID = $this->pid AND (value> 0 OR comment<>'') ORDER BY value DESC");
		$problems = array();
		if(mysql_num_rows($res)>0){
			$h = array();
			$l = array();
			$n=array();
			while($r = mysql_fetch_array($res)){
				if($r[2]>2){
					$h[] = $r[0].') ' .$r[1];
					$h[] = $r[4];
					$this->selectedEP.=$r[3].',';	
				} elseif($r[2]>0){
					$l[] = $r[0].') ' .$r[1];
					$l[] = $r[4];
					$this->selectedEP.=$r[3].',';	
				} elseif ($r[4]!=''){
					$n[] = $r[0].') ' .$r[1];
					$n[] = $r[4];
					$this->selectedEP.=$r[3].',';	
				}
			}
			$this->selectedEP.=0;
			$this->HeaderArrayBody("High Realization", $h);
			$this->Ln();
			$this->HeaderArrayBody("Low Realization", $l);
			$this->Ln();
			$this->HeaderArrayBody("Not Rated", $n);
			
		} else {
			$this->SetFont('Times','',12);
	        $this->Cell(40,6,"You have not selected anything in the Evaluation phase",0);
	        $this->Ln();
		}
	}
	private function PrintEPDescriptions(){
		if(strlen($this->selectedEP)>1){
			$res = mysql_query("SELECT epLetter, epShort, keywords, reflect FROM ex_post WHERE epID IN($this->selectedEP)");
			while($r=mysql_fetch_array($res)){
				$this->SetFont('Times','B',14);
				$this->Cell(0,6,$r[0].') '.$r[1],0,1,'L');
				if($r[2]!=''){
					$this->SetFont('Times','B',12);
					$this->Cell(0,6,"Keywords",0,1,'L');
					$this->ChapterBody($r[2]);
				}
				if($r[3]!=''){
					$this->SetFont('Times','B',12);
					$this->Cell(0,6,"Reflections",0,1,'L');
					$this->ChapterBody($r[3]);
				}
			}
		} else {
			$this->SetFont('Times','',12);
			$this->Cell(0,6,"You have not selected anything in the Evaluation phase",0,1,'L');
		}
	}
	private function PrintEPComparison(){
		$plotar = array();
		$match = array();
		$bigProblem = array();
		$bigAmbition = array();
		
		$qrq = "SELECT ea.value, ra.value, epLetter 
		FROM ex_post e, ex_post_answers ea, roleanswers ra
		WHERE ea.projectID = ".$this->pid ."
		AND ra.projectID= ".$this->pid ." 
		AND e.epID = ea.epID
		AND ea.epID = ra.roleID";
		
		$qr = mysql_query($qrq) or die(mysql_error().$qrq);
		
		$count=0;
		while($r=mysql_fetch_array($qr)){
		
			if($r[0] > 0 || $r[1]>0){
				$count++;
				$plotar[] = $r[2].'|'.$r[0].'|'.$r[1];
				$calc = $r[0]-$r[1];
				if ($calc > 1){
					$bigProblem[] = $r[2];
				} else if($calc < -1){
					$bigAmbition[] = $r[2];
				} else {
					$match[] = $r[2];
				}
			}	
		}
		if($count==0){
			$mes = "No roles or ambitions selected";
		} else {
			$mes = "None";
		}
		
		foreach($plotar as $p){
			$this->evalSendString.=$p.'*';
		}
		
		if($this->evalSendString == ''){
			$mes = "Nothing selected";
		} else {
			$mes = "None";
		}
		$this->SetFont('Times','B',12);
		$this->Cell(0,6,"Ambitions exceed realization",0,1,'L');
		$this->SetFont('Times','',12);
		$in = '';
		foreach($bigAmbition as $val){
			$in.=$val;
			if(next($bigAmbition)){
				$in.="','";
			}
		}
		$mq = mysql_query("SELECT epShort, epLetter FROM ex_post WHERE epLetter IN ('$in')") or die(mysql_error());
		if(mysql_num_rows($mq)==0){$this->Write(5, $mes);$this->Ln();}
		while($mr = mysql_fetch_array($mq)){
			$this->Write(5, $mr[1].') '.$mr[0]);
			$this->Ln();
		}
		
		$own = mysql_query("SELECT eval_exceed, eval_equal, eval_less FROM projects WHERE projectID=$this->pid"); 
		$ownAr=mysql_fetch_array($own);
		$this->Ln();
		$this->PrintOwnText('You indicated higher ambition than realization with the preceding roles. Why?', $ownAr[0]);
		/*$keys = array('rs_exceed');
		$vals = array('You ambitions are higher than the impact of the problem in the preceding roles. Why?');
		ownTextIndividual($keys, $vals, $project->getProjectID());*/
		
		$this->SetFont('Times','B',12);
		$this->Cell(0,6,"Ambitions equal realization",0,1,'L');
		$this->SetFont('Times','',12);
		$in = '';
		foreach($match as $val){
			$in.=$val;
			if(next($match)){
				$in.="','";
			}
		}
		$mq = mysql_query("SELECT epShort, epLetter FROM ex_post WHERE epLetter IN ('$in')") or die(mysql_error());
		
		if(mysql_num_rows($mq)==0){$this->Write(5, $mes);$this->Ln();}
		while($mr = mysql_fetch_array($mq)){
			$this->Write(5, $mr[1].') '.$mr[0]);
			$this->Ln();
		}
		$this->Ln();
		$this->PrintOwnText('You indicated a level of ambition that match that of realization with the preceding roles. Why?', $ownAr[1]);
		/*$keys = array('rs_equal');
		$vals = array('You ambitions equal the impact of the problem in the preceding roles. Why?');
		ownTextIndividual($keys, $vals, $project->getProjectID());*/
		
		$this->SetFont('Times','B',12);
		$this->Cell(0,6,"Ambitions less than realization",0,1,'L');
		$this->SetFont('Times','',12);
		$in = '';
		foreach($bigProblem as $val){
			$in.=$val;
			if(next($bigProblem)){
				$in.="','";
			}
		}
		
		$mq = mysql_query("SELECT epShort, epLetter FROM ex_post WHERE epLetter IN ('$in')");
		if(mysql_num_rows($mq)==0){$this->Write(5, $mes);$this->Ln();}
		while($mr = mysql_fetch_array($mq)){
			$this->Write(5, $mr[1].') '.$mr[0]);
			$this->Ln();
		}
		
		$this->Ln();
		$this->PrintOwnText('You indicated a level of ambition that is less than that of realization with the preceding roles. Why?', $ownAr[2]);
	}
	private function PrintEPGraph(){
		include_once("saveSummaryGraph.php");
		saveImage($this->evalSendString, "evSummary.png");
		//$this->Image("tempImg/evSummary.png",25,25, 100, 100);
		if($this->GetY()>100){
			$this->AddPage();
			$y=25;
		} else {
			$y=$this->GetY()+5;
		}
		$this->Image("tempImg/evSummary.png", 25, $y);
		$this->SetY($this->GetY()+150);
	
	}
	private function PrintEPImpact(){
		$res = mysql_query("SELECT eval_contribution, eval_lessons FROM projects WHERE projectID=$this->pid");
		$r=mysql_fetch_array($res);
		$this->PrintOwnText("Contribution", $r[0]);
		$this->PrintOwnText("Lessons", $r[1]);
	}
	/*Eval phase end*/
	
	/*Synthesis*/
	private function manageHeaders($h){
		
		if(!in_array($h,$this->headAr)){
			$this->SetFont('Times','',14);
			$this->Cell(0,6,$h,0,1,'L');
			$this->headAr[]=$h;
		}
	}
	function PrintSynthesis($synthesis){
		if($synthesis){
			
			$headers=array(
			'Was the project scientific reliable?', 
			'Have all scientific perspectives been integrated?', 
			'How was expert disagreement dealt with in the project?', 
			'Have facts and opinions been adequately separated?', 
			'Did the project appeared as fair to all concerned actors?', 
			'Have some actors important stakeholder groups been excluded from the project?', 
			'How have decisions regarding the project been taken?', 
			'Can we say that decisions reflect a consensus? Or have some important stakeholder groups hbeen left out?', 
			'Did the project occurred in a transparent and open process, from its planning to its end?', 
			'Did the project get enough resources?', 
			'Did the organisation have enough know-how for such a project?', 
			'How was the group dynamic (project team, other involved bodies)?', 
			'Did conflicts appear and how were they solved? Did these conflicts influence the outcome of the project?', 
			'Did the project experiences external pressures? How were such pressures handled?', 
			'Was the project flexible enough, in order to adapt to the ongoing debate or to scientific advancements?', 
			'Did the involved persons have enough reactivity and flexibility, so as to modify the project if necessary?', 
			'Did the institution allow for short-term changes?', 
			'Did the project strive for synergies with other actors active in the field?', 
			'At which stage of the project did the target groups get informed? How long time passed before others where informed about the project after its completion?', 
			'Did the target groups of the project participate in the communication process? (e.g. invite policy-makers or scientists in an expert group, in a press conference, etc.)', 
			'In which form the results of the project have been communicated?', 
			'Which communication strategy was applied? Which channels were used (e.g. reports, mass media, direct targeted communication (newsletters), web etc.)', 
			'Was it easy to understand, attractive and easily accessible for all target groups?');
		
			$res = mysql_query("SELECT sy_sci_reliable, sy_sci_integrated, sy_sci_expert, sy_sci_facts, sy_de_fair, 
			sy_de_excluded, sy_de_decisions, sy_de_consensus, sy_de_transparent, sy_pmi_ressources, sy_pmi_knowhow, 
			sy_pmi_dynamic, sy_pmi_conflicts, sy_pmi_pressure, sy_pmi_flexible, sy_pmi_reactivity, sy_pmi_shortterm, 
			sy_pmi_synergy, sy_com_inform, sy_com_participate, sy_com_results, sy_com_strategy, sy_com_accessible 
			FROM projects WHERE projectID = ".$this->pid);
		
				$r = mysql_fetch_array($res);
				for($i=0; $i<4; $i++){
					if($r[$i]!=''){
						$this->manageHeaders("Scientific Issues");
						$this->SetFont('Times','B',12);
						$this->Write(5,$headers[$i]);
						$this->Ln();
						$this->SetFont('Times','',12);
						$this->ChapterBody(nl2br($r[$i]));
		
					}	
				}
				
				for($i=4; $i<9; $i++){
					if($r[$i]!=''){
						$this->manageHeaders("Democratic Issues");
						$this->SetFont('Times','B',12);
						$this->Write(5,$headers[$i]);
						$this->Ln();
						$this->SetFont('Times','',12);
						$this->ChapterBody(nl2br($r[$i]));
					}	
				}
				
				for($i=9; $i<18; $i++){
					if($r[$i]!=''){
						$this->manageHeaders("Project-management Issues");
						$this->SetFont('Times','B',12);
						$this->Write(5,$headers[$i]);
						$this->Ln();
						$this->SetFont('Times','',12);
						$this->ChapterBody(nl2br($r[$i]));
					}	
				}
				
				for($i=18; $i<23; $i++){
					if($r[$i]!=''){
						$this->manageHeaders("Communication Issues");
						$this->SetFont('Times','B',12);
						$this->Write(5,$headers[$i]);
						$this->Ln();
						$this->SetFont('Times','',12);
						$this->ChapterBody(nl2br($r[$i]));
					}	
				}
			}
	}
	/*Synth end*/
	
	/*Log*/
	function PrintLog($log){
		if($log){
			global $member;
			$log = new Log($member, $this->pid);
			$logs = $log->returnLogsReport($this->pid);
			for($i=0; $i<sizeof($logs); $i=$i+2){
				$this->SetFont('Times','B',10);
				$this->Cell(0,6,$logs[$i],0,1,'L');
				$this->SetFont('Times','',10);
				$this->Write(5,strip_tags($logs[$i+1]));
				$this->Ln();
			}
		}
	}
	
	/**/
	function PrintFrontPage($projectName, $projectCoordinatorName){}
}

//Instanciation of inherited class
$pid = $project->getProjectID();
$pdf=new PDF();
$pdf->pid=$pid;
$pdf->reversedConditions=$reversedConditions;
$pdf->setHeader($project->getName());
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Times','',12);

$pdf->PrintFrontPage($project->getName(), $project->getCoordinatorName());
$pdf->PrintProjectInfo($_GET['pi']);
$pdf->PrintFC($_GET['fc']);
$pdf->PrintPP($_GET['pd_back'], $_GET['pd_ident'], $_GET['pd_desc']);
$pdf->PrintRS($_GET['rs_init'], $_GET['rs_selected'], $_GET['rs_desc'], $_GET['rs_warning'], $_GET['rs_comp'], $_GET['rs_graph'], $_GET['rs_goal']);

$pdf->PrintMethods($_GET['me_chosen'], $_GET['me_desc'], $_GET['me_warning'], $_GET['me_roles']);
$pdf->PrintEP($_GET['ep_documentation'], $_GET['ep_desc'], $_GET['ep_comparison'], $_GET['ep_graph'], $_GET['ep_impact']);
$pdf->PrintSynthesis($_GET['sy']);
$pdf->PrintLog($_GET['pl']);
foreach($_SESSION as $k=>$v){
	$_SESSION[$k]='';
}

foreach($_GET as $k=>$v){
	$_SESSION[$k] = 'checked="checked"';
}
$pdf->Output();//"Report.pdf", 'D'
?>
