<?php
class PageNavigator{
	private $url,$numrows,$rowstodisplay,$offset;
	
	private $numlinks;
	function __construct($url, $numrows, $rowstodisplay, $offset){
		$this->url=$url;
		$this->numrows=$numrows;
		$this->rowstodisplay=$rowstodisplay;
		$this->offset=$offset;
		$this->numlinks=ceil($this->numrows/$this->rowstodisplay);
	}
	
	function showPager(){
		$minusOne=$this->offset-1;
		$plusOne=$this->offset+1;
		echo "<div id='pager'>";
		if($this->offset!=0){
			echo "<a href='$this->url?offset=$minusOne'>";
		}
		echo "&laquo; ";
		if($this->offset!=0){
			echo "</a>";
		}
		for($i=0; $i<$this->numlinks;$i++){
			if($this->offset!=$i){
				echo "<a href='$this->url?offset=$i'>";	
			}
			echo " $i ";
			if($this->offset!=$i){
				echo "</a>";
			}
		}
		
		if($plusOne!=$this->numlinks){
			echo "<a href='$this->url?offset=$plusOne'>";
		}
		echo "&raquo; ";
		if($plusOne!=$this->numlinks){
			echo "</a>";
		}
		echo "</div>";
	}
}