<?php
/**********************************************************
*                                                         *
*                                                         *
**********************************************************/
class MailClass{
	private $email, $header, $body, $html, $mailHeaders;
	
	function __construct($email, $header, $body, $html=FALSE){
		$this->email = $email;
		$this->header=$header;
		$this->body=wordwrap($body, 70);
		if ($html){
			$this->mailHeaders = $headers = 'From: no-reply@doing-foresight.org' . "\r\n" . 'Reply-To: ' . "\r\n";
			$this->mailHeaders .= 'MIME-Version: 1.0' . "\r\n";
			$this->mailHeaders .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
			$this->sendHTML();
		} else {
			$this->mailHeaders = $headers = 'From: no-reply@doing-foresight.org' . "\r\n" . 'Reply-To: ' . "\r\n";
			$this->sendPlain();
		}
	}
	
	private function sendPlain(){
		if(mail($this->email, $this->header, $this->body)){
			return TRUE;
		} else {
			return FALSE;
		}
	}
	
	private function sendHTML(){
		$message = "<html>
		<head>
 			<title>$this->header</title>
		</head>
		<body>
 		<span>$this->body</span>
		</body>
		</html>";
		if(mail($this->email, $this->header, $message, $this->mailHeaders)){
			return TRUE;
		} else {
			return FALSE;
		}
	}
}
?>